package com.hero.ui.dialog;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.powers.EnduranceReserve;
import com.hero.objects.powers.EnduranceReserveRecovery;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ENDReserveDialog extends PowerDialog {

	private static final long serialVersionUID = -384455353332494980L;

	private JLabel recLbl;

	private JLabel recValueLbl;

	private JButton editRecBtn;

	public ENDReserveDialog(EnduranceReserve pow, boolean isNew, boolean isPower) {
		super(pow, isNew, isPower);
		power = pow;
		init();
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		gbc.gridy = 72;
		panel.add(recLbl, gbc);
		gbc.gridx = 1;
		JPanel recPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		recPanel.add(recValueLbl);
		recPanel.add(editRecBtn);
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(recPanel, gbc);
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		editRecBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				EnduranceReserveRecovery rec = ((EnduranceReserve) power)
						.getRecovery();
				rec = (EnduranceReserveRecovery) rec.clone();
				GenericDialog dialog = rec.getDialog(false, false);
				dialog.setLocationRelativeTo(ENDReserveDialog.this);
				dialog.setVisible(true);
				if (dialog.okButtonClicked) {
					((EnduranceReserve) power).setRecovery(rec);
					updateValues();
				}
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		recLbl = new JLabel("Recovery:");
		recValueLbl = new JLabel(""
				+ ((EnduranceReserve) power).getRecovery().getLevels());
		editRecBtn = new JButton("Edit");
		editRecBtn.setOpaque(false);
		editRecBtn.setMargin(new Insets(0, 0, 0, 0));
		editRecBtn.setBorderPainted(false);
		editRecBtn.setFocusPainted(false);
		editRecBtn.setContentAreaFilled(false);
		editRecBtn.setForeground(Color.blue);
	}

	@Override
	public void updateValues() {
		super.updateValues();
		recValueLbl.setText(""
				+ ((EnduranceReserve) power).getRecovery().getLevels());
	}
}